/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.quest.filter.EntityFilterType;
import dev.toma.gunsrpg.common.quests.quest.filter.IEntityFilter;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;

public class KillEntityData
implements IQuestData {
    private final IEntityFilter filter;
    private final int kills;

    public KillEntityData(IEntityFilter filter, int kills) {
        this.filter = filter;
        this.kills = kills;
    }

    protected IEntityFilter getEntityFilter() {
        return this.filter;
    }

    protected int getKillTarget() {
        return this.kills;
    }

    public String toString() {
        return String.format("KillEntities - Filter: %s, Count: %d", this.filter.toString(), this.kills);
    }

    public static final class Serializer
    implements QuestType.IQuestDataResolver<KillEntityData> {
        @Override
        public KillEntityData resolve(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            JsonElement filterElement = object.get("entities");
            Object entityFilter = EntityFilterType.resolveJsonFile(filterElement);
            int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            return new KillEntityData((IEntityFilter)entityFilter, count);
        }

        @Override
        public CompoundNBT serialize(KillEntityData data) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("kills", data.kills);
            nbt.func_218657_a("filter", (INBT)EntityFilterType.serializeNbt(data.filter));
            return nbt;
        }

        @Override
        public KillEntityData deserialize(CompoundNBT nbt) {
            return new KillEntityData((IEntityFilter)EntityFilterType.deserializeNbt(nbt.func_74775_l("filter")), nbt.func_74762_e("kills"));
        }
    }
}

